// NOUVEAU : Importer la fonction pour peupler les champs
import { populateAIFields } from './aiAssistant.js';

let configurationData = null;

// La fonction openConfigFile() est légèrement modifiée
export function openConfigFile() {
    // ... (code interne de la fonction reste le même)
    return new Promise((resolve, reject) => {
        const fileInput = document.getElementById('file-input');
        const handleFileChange = (event) => {
            const file = event.target.files[0];
            if (!file) return reject('Aucun fichier sélectionné.');
            
            const reader = new FileReader();
            reader.onload = (e) => {
                try {
                    const jsonContent = JSON.parse(e.target.result);
                    configurationData = jsonContent;
                    
                    // NOUVEAU : Appel pour mettre à jour l'interface
                    populateAIFields(configurationData);

                    console.log("Fichier chargé :", configurationData);
                    alert("Fichier de configuration chargé avec succès !");
                    resolve(configurationData);
                } catch (error) {
                    // ... (gestion d'erreur)
                } finally {
                    fileInput.removeEventListener('change', handleFileChange);
                }
            };
            reader.readAsText(file);
        };
        fileInput.addEventListener('change', handleFileChange);
        fileInput.click();
    });
}

// La fonction saveConfigFile() utilise maintenant la configuration en mémoire
export async function saveConfigFile() {
    let dataToSave = configurationData;
    if (!dataToSave) {
        alert("Aucune configuration en mémoire. Veuillez en charger une ou en créer une.");
        return;
    }
    const jsonString = JSON.stringify(dataToSave, null, 2);
    // ... (le reste de la fonction avec showSaveFilePicker reste le même)
     if (window.showSaveFilePicker) {
        try {
            const handle = await window.showSaveFilePicker({
                suggestedName: 'h5p-video-config.json',
                types: [{ description: 'Fichiers JSON', accept: { 'application/json': ['.json'] } }],
            });
            const writable = await handle.createWritable();
            await writable.write(jsonString);
            await writable.close();
            alert("Fichier enregistré !");
        } catch (err) {
            if (err.name !== 'AbortError') console.error(err);
        }
    } else {
        const blob = new Blob([jsonString], { type: 'application/json' });
        const url = URL.createObjectURL(blob);
        const link = document.createElement('a');
        link.href = url;
        link.download = 'h5p-video-config.json';
        link.click();
        URL.revokeObjectURL(url);
    }
}


export function getCurrentConfig() {
    return configurationData;
}

// NOUVEAU : Fonction pour mettre à jour la configuration depuis un autre module
export function updateCurrentConfig(newConfig) {
    configurationData = newConfig;
    console.log("Configuration mise à jour en mémoire :", configurationData);
}